      subroutine rd_ewwav(da,de,ca,nct)
*
*     determine equivalent width by straight sum between two 
*     (user) given wavelengths. Data-da, error(^2)-de, continuum-ca.
*
      implicit none
*
      integer nct
      double precision da(nct),de(nct),ca(nct)
*
*     local
      double precision wlo,whi,dtemp,ctemp,ew,wt,wv
      double precision desum,dlam
      integer i,nchlo,nchhi
*     functions
      double precision vp_wval
*
*     common command parameter list
      character*132 inchstr
      character*60 cv(24)
      real rvss(24)
      integer iv(24)
      integer nv
      common/rd_chwork/inchstr,rvss,iv,cv,nv
*
      if(rvss(2).eq.0.0.and.rvss(3).eq.0.0) then
        write(6,*) 'Wavelength limits must be given on command line'
        goto 99
      end if
      if(rvss(4).gt.0.0) then
        wlo=dble(rvss(2))*(1.0d0+dble(rvss(3))/2.99792458d5)
        whi=dble(rvss(2))*(1.0d0+dble(rvss(4))/2.99792458d5)
!        write(6,*) wlo,whi
       else
        wlo=rvss(2)
        whi=rvss(3)
      end if
      dtemp=dble(nct)/2.0d0
      call vp_chanwav(wlo,dtemp,5.0d-2,32,1)
      nchlo=int(dtemp)
      if(nchlo.lt.1) then
        write(6,*) 'low channel set to 1'
        nchlo=1
      end if
      call vp_chanwav(whi,dtemp,5.0d-2,32,1)
      nchhi=int(dtemp+0.5d0)
      if(nchhi.gt.nct.or.nchhi.le.nchlo) then
        write(6,*) 'high channel set to', nct
        nchhi=nct
      end if
      ew=0.0d0
      wt=0.0d0
      wv=0.0d0
      desum=0.0d0
      do i=nchlo,nchhi
        ctemp=1.0d0-da(i)/ca(i)
        dtemp=dble(i)-0.5d0
        dlam=vp_wval(dtemp+1.0d0,1)-vp_wval(dtemp,1)
        ew=ew+ctemp*dlam
        wt=wt+ctemp
        wv=wv+ctemp*vp_wval(dble(i))
        desum=desum+de(i)*dlam*dlam
      end do
      wv=wv/wt
      if(desum.gt.0.0d0) then
        desum=sqrt(desum)
        write(6,'(f12.4,2f14.8)') wv,ew,desum
*       copy to unit 9
        write(9,'(f12.4,2f14.8)') wv,ew,desum
       else
*       possibly for cog, so give log10(ew/wv)
        wt=log10(ew/wv)
        write(6,'(f12.4,f14.8,f12.6)') wv,ew,wt
*       copy to unit 9
        write(9,'(f12.4,f14.8,f12.6)') wv,ew,wt
      end if
99    continue
      return
      end