      SUBROUTINE SLOW(Y)
*
*       Slow-down treatment of chain binary.
*       ------------------------------------
*
      INCLUDE 'commonc.h'
      INCLUDE 'common2.h'
      LOGICAL  KSLOW,KCOLL
      REAL*8  VI(NMX3),VC(NMX3),Y(NMX8),KSCH,KSNEW
      COMMON/SLOW1/   TK2(0:NMX),EJUMP,KSCH(NMX),KSLOW,KCOLL
*     COMMON/EBSAVE/  EBS
*     COMMON/KSAVE/   K1,K2
*
*
*       Save current state vector in COMMON2.
      CALL YSAVE(Y)
*
*       Transform to physical KS coordinates and momenta.
      DO I = 1,N-1
          L1 = 3*(I-1) + 1
          KS1 = 4*(I-1) + 1
          CALL KSPHYS(Q(KS1),P(KS1),XC(L1),WC(L1))
      END DO
*
*       Obtain physical two-body velocities.
      L = 3*(N-2)
      DO K = 1,3
          VI(K) = -WC(K)/MC(1)
          VI(L+K+3) = WC(L+K)/MC(N)
      END DO
      DO I = 2,N-1
          L = 3*(I-1)
          DO K = 1,3
              VI(L+K) = (WC(L+K-3) - WC(L+K))/MC(I)
          END DO
      END DO  
      do j = 1,3*(n-1)
          vc(j) = vi(j+3) - vi(j)
      end do
*
*       Determine the largest inverse semi-major axis and chain index.
      amax = 0.0
      do i = 1,n-1
          L = 3*(i-1)
          r2 = xc(L+1)**2+xc(L+2)**2+xc(L+3)**2
          w2 = vc(L+1)**2+vc(L+2)**2+vc(L+3)**2
          r1 = sqrt(r2)
          mb = mc(i) + mc(i+1)
          ai = 2.0/r1 - w2/mb
          if (ai.gt.amax) then
              amax = ai
              i1 = i
              rm = r1
          end if
      end do
*
*       Exit if no current binary (set KSLOW = .false. just in case).
      if (amax.le.0.0d0) then
          KSLOW = .false.
          TK2(0) = 0.0
          return
      END IF
*
*       Skip modification of KSCH inside r/a = 0.1 (a might be unreliable).
      if (rm*amax.lt.0.1) then
          return
      end if
*
*       Sum the perturbations next to #i1.
      sum = 0.0
      do i = 1,n-1
          if (iabs(i-i1).eq.1) then
              j = i
              if (i.gt.i1) j = i + 1
              sum = sum + mc(j)*rinv(i)**3
          end if
      end do
*
      DEB = 0.0
      i = i1
      ainv = amax
      mb = mc(i) + mc(i+1)
*     IF (KCOLL) THEN
*         IF (INAME(I).EQ.K1.AND.INAME(I+1).EQ.K2) THEN
*             ainv = -2.0*EBS/(mc(i)*mc(i+1))
*         END IF
*     END IF
*
*       Form relative perturbation at maximum apocentre (r = 2*a).
      rap = 2.0/ainv
      pert = 2.0*sum*rap**3/mb
*
*       Specify the slow-down factor.
      IF (pert.LT.5.0D-05) THEN
*         ksnew = 5.0D-05/(pert + 1.0D-12)
*         ksnew = 1.0 + SQRT(5.0D-05/pert)
          ksnew = SQRT(5.0D-05/(pert + 1.0D-12))
          ksnew = MIN(ksnew,50.0D0)
      ELSE
          ksnew = 1.0
      END IF
*
*     --------------------------------------------------------------
*     rat = ksch(i)
*     rat = ksnew/rat
*       Check for significant changes (by 2) in slow-down factor.
*     if (rat.gt.0.5.and.rat.le.2.0) then
*         ksnew = Ksch(i)
*     else if (rat.gt.2.0) then
*         ksnew = 2*Ksch(i)
*       Allow an extra factor of 32 at initialization.
*         if (.not.KSLOW) then
*             if (rat.ge.64.0) ksnew = 32*ksnew
*         end if
*     else if (rat.le.0.5) then
*         ksnew = Ksch(i)/2
*         if (rat.le.0.125) ksnew = Ksch(i)/4
*         ksnew = max(ksnew,1.0D0)
*     end if
*     --------------------------------------------------------------
*       Check slow-down switch and include any change in binding energy.
      if (ksnew.ne.ksch(i)) then
          if (ksnew.eq.1.0d0) then
              KSLOW = .false.
*             KJUMP = .true.
          else
              KSLOW = .true.
          end if
*       Add change in binary energy and save new slow-down index.
          eb = -0.5d0*MC(i)*MC(i+1)*ainv
          DEB = DEB + eb*(1.0/ksnew - 1.0/Ksch(i))
          Ksch(i) = ksnew
      end if
*
*       Accumulate total energy difference due to slow-down.
         EJUMP = EJUMP + DEB
*
*       Form modified mass factors.
      do i = 1,n
          tk1(i) = -1.0/MC(I)
      end do
      do i = 1,n-1
          if (Ksch(i).ne.1.0d0) then
              tk1(i) = tk1(i)/Ksch(i)
              tk1(i+1) = tk1(i+1)/Ksch(i)
          end if
      end do
      DO I = 1,N-1
          TKK(I) = 0.5D0*(-tk1(i) - tk1(i+1))
          MKK(I) = MC(I)*MC(I+1)/Ksch(i)
      END DO
      do i = 1,n-1
          m12 = mc(i) + mc(i+1)
          dt12 = 0.5d0*(1.0d0 - 1.0d0/Ksch(i))/m12
          if (i.gt.1) TKK(i-1) = tkk(i-1) + dt12
          if (i.lt.n-1) TKK(i+1) = tkk(i+1) + dt12
          if (i.gt.1.and.i.lt.n-1) TK2(i) = -2.0d0*dt12
      end do
      TK2(0) = 0.0
      TK2(N) = 0.0
*
      RETURN
      END
