      SUBROUTINE KCPERT(I,I1,FIRR)
*
*
*       Perturbation on KS component due to chain.
*       ------------------------------------------
*
      INCLUDE 'common3.h'
      COMMON/CHAINC/  XC(3,NCMAX),BODYC(NCMAX),ICH,LISTC(100)
      REAL*8  FIRR(3),FP(3),FPS(3)
*
*
*       See if perturber list contains chain c.m. body #ICH. 
      NNB1 = LIST(1,I1) + 1
      DO 20 L = 2,NNB1
          J = LIST(L,I1)
*       Finish search if perturber index exceeds chain c.m. index.
          IF (J.GT.ICH) GO TO 30
*
          IF (J.EQ.ICH) THEN
*       Obtain the force on each KS component (saving the first).
              J1 = I1
              DO 10 KCOMP = 1,2
                  DO 5 K = 1,3
                      FP(K) = 0.0D0
    5             CONTINUE
                  XI = X(1,J1)
                  YI = X(2,J1)
                  ZI = X(3,J1)
                  CALL FCHAIN(J1,XI,YI,ZI,FP)
                  IF (KCOMP.EQ.1) THEN
                      DO 8 K = 1,3
                          FPS(K) = FP(K)
    8                 CONTINUE
                  END IF
                  J1 = J1 + 1
   10         CONTINUE
*
*       Add mass-weighted contributions to the current irregular force.
              BODYIN = 1.0/BODY(I)
              DO 15 K = 1,3
                  FIRR(K) = FIRR(K) + (BODY(I1)*FPS(K) +
     &                                 BODY(J1)*FP(K))*BODYIN
   15         CONTINUE
          END IF
   20 CONTINUE
*
   30 RETURN
*
      END
