      SUBROUTINE SETSYS
*
*
*       Selection of chain system.
*       --------------------------
*
      INCLUDE 'common3.h'
      PARAMETER  (NMX=10,NMX2=2*NMX,NMX3=3*NMX,NMX4=4*NMX,
     &            NMX8=8*NMX,NMXm=NMX*(NMX-1)/2)
      REAL*8  M,MASS,MC,MIJ,MKK
      COMMON/CHAIN1/  XCH(NMX3),VCH(NMX3),M(NMX),
     &                ZZ(NMX3),WC(NMX3),MC(NMX),
     &                XI(NMX3),PI(NMX3),MASS,RINV(NMXm),RSUM,MKK(NMX),
     &                MIJ(NMX,NMX),TKK(NMX),TK1(NMX),INAME(NMX),NN
      COMMON/CHAINC/  XC(3,NCMAX),BODYC(NCMAX),ICH,LISTC(100)
      COMMON/CHREG/  TIMEC,TMAX,RMAXC,CM(10),NAMEC(6),NSTEP1,KZ27,KZ30
      COMMON/INCOND/  X4(3,NMX),XDOT4(3,NMX)
*
*
*       Check whether new chain or addition of member(s).
      IF (NCH.GT.0) GO TO 10
*
*       Initialize chain indices, names & masses for largest interaction.
      DO 1 L = 1,4
          JLIST(L) = 2*NPAIRS + L
          NAMEC(L) = NAME(2*NPAIRS+L)
          BODYC(L) = BODY(2*NPAIRS+L)
          M(L) = BODY(2*NPAIRS+L)
    1 CONTINUE
      CM(9) = EBCH0

*       Include treatment for near-synchronous binary as inert body.
      IF (JCLOSE.GT.N.AND.KZ(27).GT.0.AND.KZ(26).LT.2) THEN
          IF (ABS(H(JCLOSE-N)).GT.100.0*ECLOSE) THEN
              NCH = 2
              GO TO 10
          END IF
      END IF
*
*       Define chain membership for three-body or four-body case.
      IF (JCLOSE.LE.N.AND.JCLOSE.GT.0) THEN
          NCH = 3
          JLIST(3) = JCLOSE
          NAMEC(3) = NAME(JCLOSE)
          BODYC(3) = BODY(JCLOSE)
          M(3) = BODY(JCLOSE)
      ELSE
          NCH = 4
      END IF
      GO TO 50
*
*       Improve coordinates & velocities of single perturber or c.m. body.
   10 CALL XVPRED(JCLOSE,-1)
*
*       Expand membership and save chain variables (single body or KS pair).
      IF (JCLOSE.LE.N) THEN
          NCH = NCH + 1
          JLIST(NCH) = JCLOSE
          NAMEC(NCH) = NAME(JCLOSE)
          BODYC(NCH) = BODY(JCLOSE)
          M(NCH) = BODY(JCLOSE)
      ELSE
          KSPAIR = JCLOSE - N
*       Check for synchronous tidal binary (save dormant energy in ECOLL).
          IF (KZ(27).GT.0.AND.KZ(26).LT.2) THEN
              IF (ABS(H(KSPAIR)).GT.100.0*ECLOSE) THEN
                  NCH = NCH + 1
                  JLIST(NCH) = JCLOSE
                  NAMEC(NCH) = NAME(JCLOSE)
                  BODYC(NCH) = BODY(JCLOSE)
                  M(NCH) = BODY(JCLOSE)
*       Define temporary KS ghost by saving masses and binding energy.
                  T0(2*KSPAIR-1) = 1.0E+06
                  LIST(1,2*KSPAIR-1) = 0
                  BODYC(9) = BODY(2*KSPAIR-1)
                  BODYC(10) = BODY(2*KSPAIR)
                  ZMU = BODY(2*KSPAIR-1)*BODY(2*KSPAIR)/BODY(JCLOSE)
                  ECOLL = ECOLL + ZMU*H(KSPAIR)
                  BODY(2*KSPAIR-1) = 0.0D0
                  BODY(2*KSPAIR) = 0.0D0
                  GO TO 50
              END IF
          END IF
*
*       Re-activate any merged binary before terminating as last pair.
          IF (NAME(JCLOSE).LT.0) THEN
              WRITE (6,15)  JCLOSE, RSUM,  R(JCLOSE-N)
   15         FORMAT (/,5X,'WARNING!   MERGER & CHAIN',I5,1P,2E9.1)
              CALL RESET
              KSPAIR = NPAIRS
          END IF
*
*       Terminate KS pair and copy components.
          IPHASE = 8
          CALL KSTERM
          DO 20 L = 1,2
              NCH = NCH + 1
              JLIST(NCH) = 2*NPAIRS + L
              NAMEC(NCH) = NAME(2*NPAIRS+L)
              BODYC(NCH) = BODY(2*NPAIRS+L)
              M(NCH) = BODY(2*NPAIRS+L)
   20     CONTINUE
      END IF
*
*       Specify membership for chain COMMON.
   50 NN = NCH
*
      RETURN
*
      END
