      SUBROUTINE ADJUST
*
*
*       Parameter adjustment and energy check.
*       --------------------------------------
*
      INCLUDE 'common3.h'
      COMMON/ECHAIN/  ECH
      COMMON/EXTRA2/ TINJ,DTINJ,RT,KX,NIN
      SAVE ISTART
*
*
*       Predict X & XDOT for all particles (except unperturbed pairs).
      CALL XVPRED(IFIRST,NTOT)
*
*       Obtain the total energy at current time (resolve all KS pairs).
      CALL ENERGY
*
*       Initialize c.m. terms.
      DO 10 K = 1,3
          CMR(K) = 0.0D0
          CMRDOT(K) = 0.0D0
   10 CONTINUE
*
*       Obtain c.m. & angular momentum integrals and Z-moment of inertia.
      AZ = 0.0D0
      ZM = 0.0D0
      ZMTOT = 0.0
      DO 20 I = 1,N
          DO 15 K = 1,3
              CMR(K) = CMR(K) + BODY(I)*X(K,I)
              CMRDOT(K) = CMRDOT(K) + BODY(I)*XDOT(K,I)
   15     CONTINUE
          RI2 = (X(1,I) - RDENS(1))**2 + (X(2,I) - RDENS(2))**2 +
     &                                   (X(3,I) - RDENS(3))**2
*       Skip contribution from escapers.
*         IF (RI2.GT.RTIDE**2) GO TO 20
          AZ = AZ + BODY(I)*(X(1,I)*XDOT(2,I) - X(2,I)*XDOT(1,I))
          ZM = ZM + BODY(I)*(X(1,I)**2 + X(2,I)**2)
          ZMTOT = ZMTOT + BODY(I)
   20 CONTINUE
      RTIDE = (ZMTOT/(3.0*GMG))**0.3333*RG0
      IF (TIME.LE.0.0D0) RBOUND = 0.8*RTIDE
*
*       Form c.m. coordinates & velocities (vectors & scalars).
      DO 25 K = 1,3
          CMR(K) = CMR(K)/ZMASS
          CMRDOT(K) = CMRDOT(K)/ZMASS
   25 CONTINUE
*
      CMR(4) = SQRT(CMR(1)**2 + CMR(2)**2 + CMR(3)**2)
      CMRDOT(4) = SQRT(CMRDOT(1)**2 + CMRDOT(2)**2 + CMRDOT(3)**2)
*
*       Form virial ratio using single particles & c.m. (isolated or tidal). 
      IF (KZ(14).EQ.0) THEN
          Q = ZKIN/POT
      ELSE
*       Use Chandrasekhar eq. (5.535) for virial ratio.
          ZKVIR = ZKIN + 0.5*TIDAL(4)*AZ
          Q = ZKVIR/(POT - 2.0*ETIDE)
*       Modify angular momentum integral using Chandrasekhar eq. (5.530).
          AZ = AZ + 0.5*TIDAL(4)*ZM
      END IF
*
*       Define crossing time and save single particle energy.
      ETOT = ZKIN - POT + ETIDE
      TCR = ZMASS**2.5/(2.0*ABS(ETOT))**1.5
      IF (Q.GT.1.0) THEN
          TCR = TCR*SQRT(2.0*Q)
      END IF
      E(3) = ETOT
*
*       Include KS pairs, triple & quad, chain, mergers & collisions.
      ETOT = ETOT + EBIN + ESUB + EMERGE + ECOLL
      IF (NCH.GT.0) THEN
          ETOT = ETOT + ECH
      END IF
*
*       Update energies and form the relative error (divide by ZKIN or ETOT).
      IF (TIME.LE.0.0D0) THEN
          DE = 0.0D0
          BE(1) = ETOT
          BE(3) = ETOT
*       Set provisional half-mass radius and initialize density centre.
          RSCALE = 0.5*ZMASS**2/POT
      ELSE
          BE(2) = BE(3)
          BE(3) = ETOT
          DE = BE(3) - BE(2)
          DETOT = DETOT + DE
          DE = DE/MAX(ZKIN,ABS(ETOT))
*       Save sum of relative energy error for main output and accumulate DE.
          ERROR = ERROR + DE
          ERRTOT = ERRTOT + DE
          RSCALE = 0.5*ZMASS**2/POT
      END IF
*
*       Find density centre & core radius (Casertano & Hut, Ap.J. 298, 80).
*     IF (N - NPAIRS.GT.10.AND.KZ(29).EQ.0) THEN
      IF (N-NPAIRS.GT.10) THEN
          CALL CORE
      ELSE
*       Adopt density centre at zero for small N.
          NC = N
          ZMC = ZMASS
          RC = RSCALE
          RHOD = 1.0
          RHOM = 1.0
      END IF
*
*         DO 30 K = 1,3
*             RDENS(K) = 0.0D0
*  30     CONTINUE
*
*       Check optional sorting of Lagrangian radii & half-mass radius.
      IF (KZ(7).GT.0) THEN
          CALL LAGR(RDENS)
      END IF
*
      RD = 0.0
      DO 75 K = 1,3
      RD = RD + RDENS(K)**2
   75 CONTINUE
      RD = SQRT(RD)
      RH = 0.5*ZMTOT**2/POT
      WRITE (7,777) TIME, RSCALE, RH, RD
  777 FORMAT (' HALF    ',1P,5E12.4)
      CALL FLUSH(7)
*
*       Scale average & maximum core density by the mean value.
      RHOD = 4.0*TWOPI*RHOD*RSCALE**3/(3.0*FLOAT(N))
      RHOM = 4.0*TWOPI*RHOM*RSCALE**3/(3.0*FLOAT(N))
*
*       Adopt density contrasts of unity for hot system.
      IF (KZ(29).GT.0.AND.ZKIN.GT.POT) THEN
          RHOD = 1.0
          RHOM = 1.0
      END IF
*
*       Check optional determination of regularization parameters.
      IF (KZ(16).GT.0) THEN
          RMIN0 = RMIN
*
*       Introduce equilibrium half-mass radius (predicted or actual).
          IF (KZ(7).EQ.0) THEN
              REQ = 0.25*ZMASS**2/ABS(ZKIN - POT + EMERGE)
*       Merger energy is included to avoid small denominator.
          ELSE
              REQ = RSCALE
          END IF
*
*       Form close encounter distance from scale factor & density contrast.
          RMIN = RSCALE/(FLOAT(N)*RHOM**0.3333)
          IF (TIME.GT.0.0D0) RMIN = SQRT(RMIN0*RMIN)
*       Harmonic mean reduces fluctuations (avoid using initial value).
          RMIN = MIN(RMIN,0.01*REQ)
*       Maximum value for increased efficiency (small N limit).
          DTMIN = 0.04*SQRT(ETA/0.02D0)*SQRT(RMIN**3/BODYM)
*       Scaling by accuracy parameter & <M> included for consistency.
          ECLOSE = 4.0*MAX(ZKIN,ABS(ZKIN - POT))/ZMASS
      END IF
*
*       Check optional modification of DTMIN, ECLOSE & TCR for hot system.
      IF (KZ(29).GT.0.AND.Q.GT.1.0) THEN
          DTMIN = 0.04*SQRT(ETA/0.02D0)*SQRT(RMIN**3/BODYM)
          SIGMA2 = 2.0*ZKIN/ZMASS
          VP2 = 4.0*BODYM/RMIN
          DTMIN = DTMIN*SQRT((VP2 + SIGMA2/Q)/(VP2 + 2.0D0*SIGMA2))
          ECLOSE = SIGMA2
          TCR = 2.0*RSCALE/SQRT(SIGMA2)
      END IF
*
*       Set useful scalars for the integrator.
      SMIN = 2.0*DTMIN
      RMIN2 = RMIN**2
      RMIN22 = 4.0*RMIN2
*       Specify square close encounter force from heaviest body at 5*RMIN.
      FCRIT2 = (BODY1/(25.0*RMIN2))**2
*
*       Define tidal radius for isolated system (RTIDE used in ESCAPE).
***   IF (TIDAL(1).EQ.0.0) RTIDE = 10.0*RSCALE
*
*       Print energy diagnostics & KS parameters.
      ICR = TIME/TCR
      WRITE (6,50)  TIME, Q, DE, BE(3), RMIN, DTMIN, DETOT, NIN
   50 FORMAT (/,' ADJUST:  TIME =',F8.2,'  Q =',F5.2,'  DE =',1P,E10.2,
     &          '  E =',0P,F10.6,'  RMIN =',1P,E8.1,'  DTMIN =',E8.1,
     &          '  DETOT =',E10.2,'  NIN =',0P,I4)
      CALL FLUSH(6)
      AX = 10.0
      DO 55 L = 1,NPAIRS
          SEMI = -0.5*BODY(N+L)/H(L)
          IF (SEMI.LT.0.0) GO TO 55
          AX = MIN(AX,SEMI)
   55 CONTINUE
*
*       Perform automatic error control (RETURN on restart with KZ(2) > 1).
      CALL CHECK(DE)
      IF (ABS(DE).GT.5.0*QE) GO TO 70
*
*       Check for escaper removal.
      IF (KZ(23).GT.0) THEN
          CALL ESCAPE
      END IF
*
*       Check correction for c.m. displacements.
      IF (KZ(28).GT.0) THEN
          CALL CMCORR
      END IF
*
*       See whether standard output is due.
      IF (TIME.GE.TNEXT) THEN
          CALL OUTPUT
      END IF
*
*       Update time for next adjustment.
      TADJ = TADJ + DTADJ
*
*       Obtain elapsed CPU time and update total since last output/restart.
      CALL CPUTIM(TCOMP)
      CPUTOT = CPUTOT + TCOMP - CPU0
      CPU0 = TCOMP
*
*       Save COMMON after satisfactory energy check.
      TDUMP = TIME
      IF (KZ(2).GE.1) CALL MYDUMP(1,2)
*
*       Check termination criteria (TIME > TCRIT & N <= NCRIT).
      IF (TIME.GT.TCRIT.OR.N.LE.NCRIT) THEN
      IF (KZ(27).LT.-1) THEN
          CALL REVERS
          GO TO 70
      END IF
*       Terminate after optional COMMON save.
          WRITE (6,60)  TIME, CPUTOT/60.0, ERRTOT, DETOT
   60     FORMAT (//,9X,'END RUN',3X,'TIME =',F7.2,'  CPUTOT =',F6.1,
     &                  '  ERRTOT =',F10.6,'  DETOT =',F10.6)
          IF (KZ(1).GT.0) CALL MYDUMP(1,1)
          STOP
      END IF
*
   70 RETURN
*
      END
