      SUBROUTINE CMBODY(ENERGY,NSYS)
*
*
*       Formation of c.m. body by collision.
*       ------------------------------------
*
      INCLUDE 'common3.h'
      PARAMETER  (NMX=10,NMX4=4*NMX)
      COMMON/CLOSE/  RIJ4(4,4),RCOLL4,QPERI4,SIZE4(4),ECOLL4
      COMMON/CCOLL2/  QK(NMX4),PK(NMX4),RIK(NMX,NMX),SIZE(NMX),VSTAR1,
     &                ECOLL1,RCOLL,QPERI,ISTAR(NMX),ICOLL,ISYNC,NDISS1
      REAL*8  CM(6)
      CHARACTER*8  WHICH1
*
*
*       Distinguish beteween chain and triple or quad case (ICH > 0 or = 0).
      IF (IPHASE.EQ.9) THEN
          ICH = 1
      ELSE
*       Activate collision indicator (otherwise done in CHTERM).
          ICH = 0
          IPHASE = 9
      END IF
*
*       Specify global indices of subsystem (membership: NSYS = 2, 3, 4).
      IF (NSYS.EQ.2) THEN
*       Save binding energy & separation and terminate KS pair.
          EB = BODY(2*KSPAIR-1)*BODY(2*KSPAIR)*H(KSPAIR)/BODY(N+KSPAIR)
          RB = R(KSPAIR)
          I = N + KSPAIR
          JCLOSE = 0
*
*       Check for hierarchical configuration.
          NP1 = LIST(1,2*KSPAIR-1) + 1
          DO 5 L = 2,NP1
              J = LIST(L,2*KSPAIR-1)
              RIJ2 = 0.0
              VIJ2 = 0.0
              RDOT = 0.0
              DO 2 K = 1,3
                  RIJ2 = RIJ2 + (X(K,I) - X(K,J))**2
                  VIJ2 = VIJ2 + (XDOT(K,I) - XDOT(K,J))**2
                  RDOT = (X(K,I) - X(K,J))*(XDOT(K,I) - XDOT(K,J))
    2         CONTINUE
              RIP = SQRT(RIJ2)
              A1 = 2.0/RIP - VIJ2/(BODY(I) + BODY(J))
              A1 = 1.0/A1
              IF (1.0/A1.GT.0.5/RMIN) THEN
                  ECC2 = (1.0 - RIP/A1)**2 +
     &                                  RDOT**2/(A1*(BODY(I) + BODY(J)))
                  RP = A1*(1.0 - SQRT(ECC2))
                  A0 = -0.5*BODY(I)/H(KSPAIR)
                  ECC = 1.0 - R(KSPAIR)/A0
                  RA = A0*(1.0 + ECC)
                  SR = RP/RA
                  WRITE (6,4)  KSPAIR, J, H(KSPAIR), A0, A1, RP,
     &                         SQRT(ECC2), SR
    4             FORMAT (' HIERARCHY:   IPAIR J H A0 A1 RP E1 SR',
     &                                   I4,I5,F7.0,1P3E9.1,0PF6.2,F6.1)
              END IF
*       Select closest single body inside 0.5*RMIN as KS component.
              IF (RIP.LT.0.5*RMIN.AND.J.LE.N) THEN
                  IF (JCLOSE.GT.0) THEN
                      IF (RIP.GT.RIP0) GO TO 5
                      JCLOSE = J
                      RIP0 = RIP
                  ELSE
                      JCLOSE = J
                      RIP0 = RIP
                  END IF
              END IF
    5     CONTINUE
*
*       Update body #JCLOSE to current time for new KS with combined c.m.
          IF (JCLOSE.GT.0) THEN
              CALL XVPRED(JCLOSE,-1)
              T0(JCLOSE) = TIME
              DO 8 K = 1,3
                  X0DOT(K,JCLOSE) = XDOT(K,JCLOSE)
                  X0(K,JCLOSE) = X(K,JCLOSE)
    8         CONTINUE
          END IF
*
*       Terminate KS pair and set relevant indices for collision treatment.
          CALL KSTERM
          I1 = 2*NPAIRS + 1
          I2 = I1 + 1
          I3 = 0
          ICOMP = I1
          RCOLL = RB
          WHICH1 = ' BINARY '
      ELSE
          I1 = JLIST(1)
          I2 = JLIST(2)
          I3 = JLIST(3)
          I4 = JLIST(4)
*       Case of three-body system is denoted by JLIST(5) = -1.
      END IF
*
*       Form global c.m. coordinates & velocities from body #I1 & I2.
      ZM = BODY(I1) + BODY(I2)
      DO 10 K = 1,3
          CM(K) = (BODY(I1)*X(K,I1) + BODY(I2)*X(K,I2))/ZM
          CM(K+3) = (BODY(I1)*XDOT(K,I1) + BODY(I2)*XDOT(K,I2))/ZM
   10 CONTINUE
*
*       Create new body from c.m. and initialize zero mass ghost in #I2.
      BODY(I1) = ZM
      BODY(I2) = 0.0D0
      T0(I2) = TADJ + DTADJ 
      STEP(I2) = 1.0D+06
      RI = SQRT(X(1,I2)**2 + X(2,I2)**2 + X(3,I2)**2)
      VI = SQRT(XDOT(1,I2)**2 + XDOT(2,I2)**2 + XDOT(3,I2)**2)
*
      DO 30 K = 1,3
          X(K,I1) = CM(K)
          X0(K,I1) = CM(K)
          XDOT(K,I1) = CM(K+3)
          X0DOT(K,I1) = CM(K+3)
*       Ensure that ghost will escape at next output (KZ(23) > 0).
          X0(K,I2) = 1000.0*RSCALE*X(K,I2)/RI
          X(K,I2) = X0(K,I2)
          X0DOT(K,I2) = SQRT(0.004*ZMASS/RSCALE)*XDOT(K,I2)/VI
          XDOT(K,I2) = X0DOT(K,I2)
          F(K,I2) = 0.0D0
          FDOT(K,I2) = 0.0D0
          FDOT2(K,I2) = 0.0D0
          D2(K,I2) = 0.0D0
          D3(K,I2) = 0.0D0
   30 CONTINUE
*
*       Remove the ghost particle from perturber lists containing #I1.
      JLIST(1) = I2
      CALL NBREM(I1,1,NPAIRS)
*
*       Decide appropriate path for each case.
      IF (NSYS.EQ.2) GO TO 40
      IF (NSYS.EQ.3) GO TO 45
*
*       Switch KS components if body #I3 & I4 is closer than #I1 & I3.
      IF (JLIST(5).LT.0) THEN
          I4 = I1
          I1 = JLIST(4)
      END IF
*
*       Obtain dominant F & FDOT on body #I1 & I3 for #I4 in FPOLY2.
      JLIST(1) = I1
      JLIST(2) = I3
      JLIST(3) = I4
      ICOMP = I4
*
      CALL FCLOSE(I1,3)
      CALL FCLOSE(I3,3)
*
*       Predict all other coordinates & velocities in case of KS collision.
   40 IF (NSYS.EQ.2) THEN
          T0(ICOMP) = TIME
          CALL XVPRED(IFIRST,NTOT)
*       Perform immediate KS regularization with close hierarchical body.
          IF (JCLOSE.GT.0) THEN
              ICOMP = I1
              JCOMP = JCLOSE
              CALL KSREG
              GO TO 80
          END IF
      END IF
*
*       Initialize force polynomial for new single or third body (ICOMP).
      CALL FPOLY1(ICOMP,ICOMP,0)
      CALL FPOLY2(ICOMP,ICOMP,0)
*
*       See whether body #ICOMP should be added to NLIST.
      IF (T0(ICOMP) + STEP(ICOMP).LT.TLIST) THEN
          CALL NLMOD(ICOMP,1)
      END IF
      IF (NSYS.EQ.2) GO TO 80
*
*       Obtain binding energy of the subsystem (2 or 3 members).
   45 ZKE = 0.0D0
      POTS = 0.0D0
      I = I1
      J = I3
   50 ZKE = ZKE + BODY(I)*(XDOT(1,I)**2 + XDOT(2,I)**2 + XDOT(3,I)**2)
*       Note that variable ENERGY also contains c.m. kinetic energy.
      IF (I.EQ.I3.AND.NSYS.EQ.3) GO TO 60
      IF (I.EQ.I4) GO TO 60
   55 RIJ2 = (X(1,I) - X(1,J))**2 + (X(2,I) - X(2,J))**2 +
     &                              (X(3,I) - X(3,J))**2
      POTS = POTS + BODY(I)*BODY(J)/SQRT(RIJ2)
*
*       Include all interactions.
      IF (I.EQ.I1.AND.NSYS.EQ.4) THEN
          IF (J.EQ.I3) THEN
              J = I4
              GO TO 55
          ELSE
              I = I3
              J = I4
              GO TO 50
          END IF
      END IF
*
*       Add kinetic energy from last body and check DMIN in TRIPLE or QUAD.
      IF (ICH.GT.0) THEN
          I = I3
          IF (NSYS.GT.3) I = I4
          WHICH1 = '  CHAIN '
          RCOLL = DMINC
      ELSE IF (NSYS.EQ.3) THEN
          I = I3
          WHICH1 = ' TRIPLE '
          DMIN3 = MIN(DMIN3,RCOLL)
      ELSE
          I = I4
          WHICH1 = '   QUAD '
          DMIN4 = MIN(DMIN4,RCOLL)
      END IF
*
      GO TO 50
*
*       Form net energy correction for triple or quad case.
   60 EB = ENERGY - (0.5D0*ZKE - POTS)
      RB = SQRT(RIJ2)
*
*       Set global components for new KS regularization (ICOMP < JCOMP).
      ICOMP = MIN(I1,I3)
      JCOMP = MAX(I1,I3)
*
*       Initialize new KS pair.
      CALL KSREG
*
*       Update energy loss & collision counters.
   80 ECOLL = ECOLL + EB
      E(10) = E(10) + EB
      NPOP(8) = NPOP(8) + 1
      NCOUNT(28) = NCOUNT(28) + 1
      NCOLL = NCOLL + 1
*
      WRITE (6,90)  WHICH1, NSYS, NAME(I1), NAME(I2), RCOLL, RB, EB,
     &              BE(3)
   90 FORMAT (/,A8,'COLLISION    NSYS =',I3,'  NAME =',2I4,
     &             '  RCOLL =',1P,E8.1,'  R =',E8.1,'  EB =',0P,F9.5,
     &             '  E =',F10.6)
*
*       Set IPHASE < 0 since routine INTGRT exits on IPHASE > 0.
      IPHASE = -1
*
      RETURN
*
      END
