      SUBROUTINE CMCORR
*
*
*       Center of mass & regular force corrections.
*       -------------------------------------------
*
      INCLUDE 'common3.h'
*
*
*       Initialize centre of mass variables.
      DO 10 K = 1,3
          CMR(K) = 0.0D0
          CMRDOT(K) = 0.0D0
   10 CONTINUE
*
*       Form c.m. coordinate & velocity displacements.
      DO 20 I = IFIRST,NTOT
          DO 15 K = 1,3
              CMR(K) = CMR(K) + BODY(I)*X(K,I)
              CMRDOT(K) = CMRDOT(K) + BODY(I)*XDOT(K,I)
   15     CONTINUE
   20 CONTINUE
*
      DO 30 K = 1,3
          CMR(K) = CMR(K)/ZMASS
          CMRDOT(K) = CMRDOT(K)/ZMASS
   30 CONTINUE
*
*       Apply c.m. corrections to X & XDOT and accumulate energy changes.
      ERRX = 0.0D0
      ERRV = 0.0D0
      DO 40 I = IFIRST,NTOT
          DO 35 K = 1,3
              XI2 = X(K,I)**2
              VI2 = XDOT(K,I)**2
              X(K,I) = X(K,I) - CMR(K)
              XDOT(K,I) = XDOT(K,I) - CMRDOT(K)
              ERRX = ERRX - TIDAL(K)*BODY(I)*(X(K,I)**2 - XI2)
              ERRV = ERRV + BODY(I)*(XDOT(K,I)**2 - VI2)
   35     CONTINUE
   40 CONTINUE
*
*       Adjust the total energy to new kinetic energy & tidal potential.
      BE(3) = BE(3) + 0.5*(ERRX + ERRV)
*
*       Perform a consistent shift of the density centre.
      DO 50 K = 1,3
          RDENS(K) = RDENS(K) - CMR(K)
   50 CONTINUE
*
*       Subtract tidal corrections from regular force & first derivative.
      DO 60 I = IFIRST,NTOT
          DO 55 K = 1,3
              DF = TIDAL(K)*CMR(K)
              DD = TIDAL(K)*CMRDOT(K)
              F(K,I) = F(K,I) - 0.5*DF
              D1(K,I) = D1(K,I) - DD
              FDOT(K,I) = FDOT(K,I) - ONE6*DD
   55     CONTINUE
   60 CONTINUE
*
*       Redetermine X0 & X0DOT consistently with current corrected X & XDOT.
      DO 70 I = IFIRST,NTOT
          DT = TIME - T0(I)
          A1 = 0.05D0*DT
          A2 = 0.25D0*DT
          A3 = (T0(I) - T1(I)) + (T0(I) - T2(I))
          DO 65 K = 1,3
              F2DOTK = D3(K,I)*A3 + D2(K,I)
              F3DOTK = D3(K,I)
              DV0 = (((F3DOTK*A2 + ONE3*F2DOTK)*DT +
     &                            3.0D0*FDOT(K,I))*DT + 2.0D0*F(K,I))*DT
              X0DOT(K,I) = XDOT(K,I) - DV0
              DX0 = ((((F3DOTK*A1 + ONE12*F2DOTK)*DT + FDOT(K,I))*DT +
     &                                       F(K,I))*DT + X0DOT(K,I))*DT
              X0(K,I) = X(K,I) - DX0
   65     CONTINUE
   70 CONTINUE
*
*       Ensure consistent coordinates & velocities for binary components.
      DO 80 IPAIR = 1,NPAIRS
          IF (BODY(N+IPAIR).GT.0.0D0) THEN
              CALL RESOLV(IPAIR,1)
          END IF
   80 CONTINUE
*
      RETURN
*
      END
