      SUBROUTINE INJECT
*
*
*       Injection of external member.
*       -----------------------------
*
      INCLUDE 'common3.h'
      COMMON/EXTRA2/ TINJ,DTINJ,RT,KX,NIN
      SAVE ISTART, ALPHA
*
*
      IF (ISTART.EQ.0) THEN
          ISTART = 1
          NIN = 0
          KX = 0
          ALPHA = 0.0
*         READ (5,*)  RT
          RT = RBOUND
      END IF
*
*       Create extra memory for intruder in new location N.
      DO 5 I = NTOT+1,N+1,-1
          J = I - 1
          DO 2 K = 1,3
              X(K,I) = X(K,J)
              X0(K,I) = X0(K,J)
              X0DOT(K,I) = X0DOT(K,J)
              XDOT(K,I) = XDOT(K,J)
              F(K,I) = F(K,J)
              FDOT(K,I) = FDOT(K,J)
              FDOT2(K,I) = FDOT2(K,J)
              D1(K,I) = D1(K,J)
              D2(K,I) = D2(K,J)
              D3(K,I) = D3(K,J)
    2     CONTINUE
*
          BODY(I) = BODY(J)
          RADIUS(I) = RADIUS(J)
          NAME(I) = NAME(J)
          STEP(I) = STEP(J)
          T0(I) = T0(J)
          T1(I) = T1(J)
          T2(I) = T2(J)
          T3(I) = T3(J)
    5 CONTINUE
*
*       Increase N and place intruder in last single body location.
      N = N + 1
      NTOT = NTOT + 1
      I = N
      DO 8 K = 1,3
          X(K,I) = 0.0
          XDOT(K,I) = 0.0
          X0DOT(K,I) = 0.0
    8 CONTINUE
      BODY(I) = BODYM
      ZMASS = ZMASS + BODY(I)
*       Increase phase by 90 degrees to avoid small separation.
      KX = KX + 1
      ALPHA = ALPHA + TWOPI*KX/180.0
*       Save intruder in 2D rotated position.
      X(1,I) = RT*COS(ALPHA)
      X(2,I) = RT*SIN(ALPHA)
      DO 9 K = 1,3
          X0(K,I) = X(K,I)
    9 CONTINUE
*
*       Obtain potential energy correction after adding new body.
      POT1 = 0.0
      DO 20 J = IFIRST,NTOT
          IF (J.EQ.I) GO TO 20
          RIJ2 = 0.0
          DO 10 K = 1,3
              RIJ2 = RIJ2 + (X(K,I) - X(K,J))**2
   10     CONTINUE
          POT1 = POT1 + BODY(J)/SQRT(RIJ2)
   20 CONTINUE
*
*       Initialize force polynomial and time-step (see FPOLY2).
      CALL FPOLY1(I,I,0)
      CALL FPOLY2(I,I,0)
*
*       Perform energy correction for zero velocity intruder.
      BE(3) = BE(3) - BODY(I)*POT1
*
      WRITE (6,30)  N, BE(3), BODY(I)*POT1
   30 FORMAT (' INJECT   N BE3 DE ',I5,F10.6,1P,E10.2)
      CALL FLUSH(6)
*       Update perturber lists beyond J = N.
      DO 50 L = 1,NPAIRS
          J1 = 2*L - 1
          IF (LIST(1,J1).EQ.0) GO TO 50
          NP1 = LIST(1,J1) + 1
          IF (LIST(NP1,J1).LT.N) GO TO 50
          DO 45 LL = 2,NP1
              LIST(LL,J1) = LIST(LL,J1) + 1
   45     CONTINUE
   50 CONTINUE
*
*       Update event counter and injection time (see INTGRT).
      NIN = NIN + 1
      TINJ = TINJ + DTINJ
      IF (NTOT.GT.NMAX - 2) THEN
          WRITE (6,60)  TIME, NTOT, NIN
   60     FORMAT (' LIMIT EXCEEDED!    T NTOT NIN ',F8.2,3I5)
          STOP
      END IF
*
      RETURN
*
      END
