      SUBROUTINE INTIDE
*
*
*       Input & scaling for tidal capture.
*       ----------------------------------
*
      INCLUDE 'common3.h'
*
*
*       Read parameters for tidal capture simulation.
      READ (5,*)  RSTAR, RTSTAR, RSYNC, EPOCH
*
*       Convert stellar radii from AU to internal length units.
      RSTAR = RSTAR/(AU*RBAR)
      RTSTAR = RTSTAR/(AU*RBAR)
      RSYNC = RSYNC/(AU*RBAR)
*
*       Initialize event counter.
      DO 5 K = 1,10
          NTYPE(K) = 0
    5 CONTINUE
*
      WRITE (6,10)  RSTAR, RTSTAR, RSYNC, EPOCH
   10 FORMAT (/,12X,'TIDAL CAPTURE:   RSTAR =',1PE8.1,'  RTSTAR =',E8.1,
     &                                '  RSYNC =',E8.1,'  EPOCH =',E8.1)
*
      READ (5,*)  IMS, IEV, RMS, REV
      WRITE (6,25)  IMS, IEV, RMS, REV
   25 FORMAT (/,12X,'STELLAR RADII:   IMS =',I5,'  IEV =',I4,
     &                        '  RMS/RSTAR =',F5.2,'  REV/RSTAR =',F6.3)
*
*       Assign individual radii for main-sequence and evolved stars.
      DO 30 I = 1,N
          IF (I.LE.IMS) THEN
              RADIUS(I) = RMS*RSTAR
          ELSE IF (IEV.GE.0) THEN
              RADIUS(I) = REV*RSTAR
          ELSE
*       Adopt an approximate realistic value (IEV < 0; possible scaling).
              ZM = BODY(I)*SMU
              RADIUS(I) = IABS(IEV)*SQRT(ZM)/SU
          END IF
   30 CONTINUE
*
      RETURN
*
      END
