      SUBROUTINE KSREG
*
*
*       New KS regularization.
*       ----------------------
*
      INCLUDE 'common3.h'
      REAL*8  SAVE(8)
      EXTERNAL RENAME
*
*
*       Save basic variables for components unless in correct location.
      DO 10 KCOMP = 1,2
*       Treat the first & second component in turn.
         IF (KCOMP.EQ.1) THEN
             I = ICOMP
         ELSE
             I = JCOMP
         END IF
         J = 2*NPAIRS + KCOMP
         IF (I.EQ.J) GO TO 10
*
          DO 2 K = 1,3
              SAVE(K) = X(K,I)
              SAVE(K+3) = X0DOT(K,I)
    2     CONTINUE
          SAVE(7) = BODY(I)
          SAVE(8) = RADIUS(I)
          NAMEI = NAME(I)
*
*       Exchange first & second single particle with ICOMP & JCOMP.
          DO 4 K = 1,3
              X(K,I) = X(K,J)
              X0(K,I) = X0(K,J)
              X0DOT(K,I) = X0DOT(K,J)
              XDOT(K,I) = XDOT(K,J)
              F(K,I) = F(K,J)
              FDOT(K,I) = FDOT(K,J)
              FDOT2(K,I) = FDOT2(K,J)
              D1(K,I) = D1(K,J)
              D2(K,I) = D2(K,J)
              D3(K,I) = D3(K,J)
              X(K,J) = SAVE(K)
              X0DOT(K,J) = SAVE(K+3)
    4     CONTINUE
*
          BODY(I) = BODY(J)
          RADIUS(I) = RADIUS(J)
          NAME(I) = NAME(J)
          STEP(I) = STEP(J)
          T0(I) = T0(J)
          T1(I) = T1(J)
          T2(I) = T2(J)
          T3(I) = T3(J)
          BODY(J) = SAVE(7)
          RADIUS(J) = SAVE(8)
          NAME(J) = NAMEI
   10 CONTINUE
*
*       Increase pair index, total number & single particle index.
      NPAIRS = NPAIRS + 1
      NTOT = N + NPAIRS
      IFIRST = 2*NPAIRS + 1
*
*       Update all relevant COMMON list arrays.
      CALL RENAME
*
*       Set components in JLIST(1&2) for updating NLIST in FPOLY.
      JLIST(1) = ICOMP
      JLIST(2) = JCOMP
*
*       Initialize the regularized solution.
      CALL KSINIT
*
*       Check updating of global index for chain c.m.
      IF (NCH.GT.0) THEN
          CALL CHFIND
      END IF
*
      RETURN
*
      END
