      SUBROUTINE REMOVE(I,KCASE)
*
*
*       Particle removal.
*       -----------------
*
      INCLUDE 'common3.h'
      REAL*8  A(6)
*
*
*       Remove escaper, KS pair, components or c.m. (KCASE = 1, 2, 3).
      IF (KCASE.EQ.2) GO TO 20
      IF (KCASE.EQ.3) GO TO 10
*
*       Correct force & first derivative of all bodies (only for escape).
      DO 5 J = IFIRST,NTOT
          IF (J.EQ.I) GO TO 5
          RIJ2 = 0.0D0
          A7 = 0.0D0
          DO 1 K = 1,3
              A(K) = X(K,I) - X(K,J)
              A(K+3) = XDOT(K,I) - XDOT(K,J)
              RIJ2 = RIJ2 + A(K)**2
              A7 = A7 + A(K)*A(K+3)
    1     CONTINUE
          A8 = BODY(I)/(RIJ2*SQRT(RIJ2))
          DO 2 K = 1,3
              A(K+3) = (A(K+3) - 3.0*A7*A(K)/RIJ2)*A8
              F(K,J) = F(K,J) - 0.5*A(K)*A8
              FDOT(K,J) = FDOT(K,J) - ONE6*A(K+3)
              D1(K,J) = D1(K,J) - A(K+3)
    2     CONTINUE
    5 CONTINUE
*
*       Move up all COMMON variables (escaper or old c.m. & KS comps).
   10 IF (I.GT.NTOT) GO TO 50
*
      DO 15 J = I,NTOT
          J1 = J + 1
          DO 12 K = 1,3
              X(K,J) = X(K,J1)
              X0(K,J) = X0(K,J1)
              X0DOT(K,J) = X0DOT(K,J1)
              XDOT(K,J) = XDOT(K,J1)
              F(K,J) = F(K,J1)
              FDOT(K,J) = FDOT(K,J1)
              FDOT2(K,J) = FDOT2(K,J1)
              D1(K,J) = D1(K,J1)
              D2(K,J) = D2(K,J1)
              D3(K,J) = D3(K,J1)
   12     CONTINUE
*
          BODY(J) = BODY(J1)
          RADIUS(J) = RADIUS(J1)
          NAME(J) = NAME(J1)
          STEP(J) = STEP(J1)
          T0(J) = T0(J1)
          T1(J) = T1(J1)
          T2(J) = T2(J1)
          T3(J) = T3(J1)
   15 CONTINUE
*
      GO TO 50
*
*       Move up all tables of KS pairs below IPAIR = I.
   20 DO 30 JPAIR = I,NPAIRS
          JP1 = JPAIR + 1
          DO 25 K = 1,4
              U(K,JPAIR) = U(K,JP1)
              U0(K,JPAIR) = U0(K,JP1)
              UDOT(K,JPAIR) = UDOT(K,JP1)
              FU(K,JPAIR) = FU(K,JP1)
              FUDOT(K,JPAIR) = FUDOT(K,JP1)
              D1U(K,JPAIR) = D1U(K,JP1)
              D2U(K,JPAIR) = D2U(K,JP1)
              D3U(K,JPAIR) = D3U(K,JP1)
   25     CONTINUE
*
          R(JPAIR) = R(JP1)
          R0(JPAIR) = R0(JP1)
          DTAU(JPAIR) = DTAU(JP1)
          TDOT2(JPAIR) = TDOT2(JP1)
          TDOT3(JPAIR) = TDOT3(JP1)
          GAMMA(JPAIR) = GAMMA(JP1)
          H(JPAIR) = H(JP1)
          HDOT(JPAIR) = HDOT(JP1)
          D1HDOT(JPAIR) = D1HDOT(JP1)
          D2HDOT(JPAIR) = D2HDOT(JP1)
          D3HDOT(JPAIR) = D3HDOT(JP1)
          T0U(JPAIR) = T0U(JP1)
          T1U(JPAIR) = T1U(JP1)
          T2U(JPAIR) = T2U(JP1)
          T3U(JPAIR) = T3U(JP1)
          KSLOW(JPAIR) = KSLOW(JP1)
*
*       Transfer two perturber lists for each pair.
          DO 29 KCOMP = 1,2
              NNB = LIST(1,2*JPAIR+KCOMP) + 1
*       Include flag of 2nd component.
              IF (NNB.EQ.1) NNB = 2
              DO 28 L = 1,NNB
                  LIST(L,2*JPAIR-2+KCOMP) = LIST(L,2*JPAIR+KCOMP)
   28         CONTINUE
   29     CONTINUE
   30 CONTINUE
*
   50 RETURN
*
      END
