      SUBROUTINE START
*
*
*       Initialization of data & polynomials.
*       -------------------------------------
*
      INCLUDE 'common3.h'
      EXTERNAL SCALE
*
*
*       Initialize global scalars, counters & useful constants.
      CALL ZERO
*
*       Read input parameters.
      CALL INPUT
*
*       Set initial conditions: BODY(I), X(K,I), XDOT(K,I); I=1,N & K=1,3.
      CALL DATA
*
      DO 6 I = 1,NHI0
          BODY(I) = 2.0*BODY(I)
    6 CONTINUE
*       Scale initial conditions to new units.
      CALL SCALE
*
*       Set total mass in case routines DATA & SCALE are not used.
      ZMASS = 0.0D0
      DO 10 I = 1,N
          ZMASS = ZMASS + BODY(I)
   10 CONTINUE
*
*       Define mean mass in scaled units and solar mass conversion factor.
      BODYM = ZMASS/FLOAT(N)
      ZMBAR = ZMBAR/BODYM
*
*       Introduce scaling factors DAYS, YRS, SU, RAU, SMU, TSTAR & VSTAR.
      CALL UNITS
*
*       Check option for external force.
      IF (KZ(14).GT.0) THEN 
          CALL XTRNL0
      ELSE
*       Define nominal time scale & velocity scale (RBAR = 1 & ZMBAR = 1).
          TSCALE = 14.94/SQRT(FLOAT(N))
          VSTAR = 0.0655*SQRT(FLOAT(N))
          DO 20 K = 1,4
              TIDAL(K) = 0.0D0
   20     CONTINUE
      END IF 
*
*       Check optional scaling to hot system.
      IF (KZ(29).GT.0) THEN
          CALL HOTSYS
      END IF
*
*       Check option for initial binaries.
      IF (KZ(8).EQ.1.OR.KZ(8).EQ.3) THEN
          CALL BINPOP
      END IF
*
*       Include primordial triples.
      IF (KZ(18).GT.2.AND.KZ(8).GT.0.AND.NHI0.GT.0) THEN
          CALL HIPOP
      END IF
*
*       Check optional initialization for tidal two-body capture.
      IF (KZ(27).GT.0) THEN
          CALL INTIDE
      END IF
*
*       Set sequential name, maximum mass & primary velocity.
      BODY1 = 0.0
      DO 30 I = 1,N
          NAME(I) = I
          BODY1 = MAX(BODY1,BODY(I))
          DO 25 K = 1,3
              X0DOT(K,I) = XDOT(K,I)
   25     CONTINUE
   30 CONTINUE
*
*       Obtain total force & first derivative.
      CALL FPOLY1(1,N,0)
*
*       Obtain second & third force derivatives.
      CALL FPOLY2(1,N,0)
*
*       Regularize any hard primordial binaries (assume sequential ordering).
      IF (NBIN0.GT.0) THEN
          DO 50 IPAIR = 1,NBIN0
              ICOMP = 2*IPAIR - 1
              JCOMP = 2*IPAIR
              RIJ2 = 0.0
*       Include standard distance criterion.
              DO 45 K = 1,3
                  RIJ2 = RIJ2 + (X(K,ICOMP) - X(K,JCOMP))**2
   45         CONTINUE
              IF (RIJ2.LT.RMIN**2) THEN
                  CALL KSREG
              END IF
   50     CONTINUE
      END IF
*
*       Initialize the time-step list used to find next body.
      DTLIST = 100.0
      DO 70 I = 1,NTOT
          DTLIST = MIN(DTLIST,STEP(I))
   70 CONTINUE
*
*       Set initial time-step list interval twice the smallest step.
      IF (N.GT.10) THEN
          DTLIST = 2.0*DTLIST
      ELSE
          DTLIST = TCRIT
      END IF
      NNB = 1
   80 TLIST = TLIST + DTLIST
*
*       Select all members due in the interval (0,TLIST).
      DO 90 J = 1,NTOT
          IF (T0(J) + STEP(J).LT.TLIST) THEN
              NNB = NNB + 1
              NLIST(NNB) = J
          END IF
   90 CONTINUE
*
*       Check whether membership range is acceptable. 
      IF (NNB.EQ.1) GO TO 80
*
*       Reduce new DTLIST to prevent early crowding and set membership.
      DTLIST = 0.2*DTLIST
      NLIST(1) = NNB - 1
*
      RETURN
*
      END
