      SUBROUTINE STEPS(I1,I2,KCASE)
*
*
*       Initialization of time-steps & differences.
*       -------------------------------------------
*
      INCLUDE 'common3.h'
      REAL*8  F2DOT(4),F3DOT(4)
*
*
*       Set new steps and initialize divided differences.
      DO 40 I = I1,I2
*
*       Obtain standard time-step using the composite formula.
      FI2 = F(1,I)**2 + F(2,I)**2 + F(3,I)**2
      DI2 = D1(1,I)**2 + D1(2,I)**2 + D1(3,I)**2
*
      DO 10 K = 1,3
          F2DOT(K) = D2(K,I)
          F3DOT(K) = D3(K,I)
   10 CONTINUE
*
      F2DOT(4) = F2DOT(1)**2 + F2DOT(2)**2 + F2DOT(3)**2
      F3DOT(4) = F3DOT(1)**2 + F3DOT(2)**2 + F3DOT(3)**2
*
*       Use dominant second derivative (F2DOT = F**2/RSCALE) in rare case.
      IF (F2DOT(4).LT.(FI2/RSCALE)**2) THEN
          F2DOT(4) = (FI2/RSCALE)**2
      END IF
*
      DT2 = (SQRT(FI2*F2DOT(4)) + DI2)/(SQRT(DI2*F3DOT(4)) + F2DOT(4))
      STEP(I) = SQRT(ETA*DT2)
*
*       Reduce time-step if c.m. approximation is used for F2DOT & F3DOT.
      IF (KCASE.EQ.1) THEN
          RIJ2 = 0.0
          FIJ2 = 0.0
          DO 15 K = 1,3
              RIJ2 = RIJ2 + (X(K,ICOMP) - X(K,JCOMP))**2
              FIJ2 = FIJ2 + (F(K,ICOMP) - F(K,JCOMP))**2
   15     CONTINUE
          GI = SQRT(FIJ2)*RIJ2/BODY(NTOT)
*       Actual perturbation on relative motion of body #ICOMP & JCOMP.
          STEP(I) = STEP(I)/(1.0 + 1000.0*GI)**0.3333
*       Apply additional convergence test using correct FI & D1.
          DTI = ETA*SQRT(FI2/DI2)
          STEP(I) = MIN(DTI,STEP(I))
      ELSE
*       Also reduce step for special case of triple, quad, merger or reflect.
          IF (IPHASE.GE.4) STEP(I) = 0.5*STEP(I)
          IF (IPHASE.EQ.8) STEP(I) = 0.5*STEP(I)
          IF (KZ(29).GT.0.AND.I.GT.N) THEN
              STEP(I) = STEP(I)/(1.0 + 1000.0*GAMMA(I-N))**0.3333
          END IF
      END IF 
*
*       Initialize the backward times.
      T0(I) = TIME
      T1(I) = TIME - STEP(I)
      T2(I) = TIME - 2.0*STEP(I)
      T3(I) = TIME - 3.0*STEP(I)
      DT1 = STEP(I)
*
*       Convert from derivatives to divided differences.
      DO 30 K = 1,3
          D1(K,I) = (ONE6*D3(K,I)*DT1 - 0.5D0*D2(K,I))*DT1 + D1(K,I)
*       Save 1/24 of second derivative for more accurate prediction.
          FDOT2(K,I) = D2(K,I)/24.0D0
          D2(K,I) = 0.5D0*D2(K,I) - 0.5D0*D3(K,I)*DT1
          D3(K,I) = ONE6*D3(K,I)
*       Initialize primary coordinates (X0DOT set by START, KSREG or KSTERM).
          X0(K,I) = X(K,I)
          F(K,I) = 0.5D0*F(K,I)
          FDOT(K,I) = ONE6*FDOT(K,I)
*       Half the force and sixth the first derivative for fast prediction.
   30 CONTINUE
   40 CONTINUE
*
      RETURN
*
      END
