      SUBROUTINE KSLIST(IPAIR)
*
*
*       KS perturber selection.
*       -----------------------
*
      INCLUDE 'common6.h'
      INCLUDE 'kscmn6.h'
*
*
*       Set component & c.m. index and form semi-major axis & eccentricity.
      I1 = 2*IPAIR - 1
      I = N + IPAIR
      SEMI = -0.5D0*BODY(I)/H(IPAIR)
      EB = -0.5*BODY(I1)*BODY(I1+1)/SEMI
      ECC2 = (1.0 - R(IPAIR)/SEMI)**2 + TDOT2(IPAIR)**2/(BODY(I)*SEMI)
      ECC = SQRT(ECC2)
*
*       Use semi-major axis and/or RMIN for perturber selection.
      IF (EB.LT.EBH) THEN
          RAP = SEMI*(1.0 + ECC)
      ELSE
*       Include a tapered criterion depending on energy for soft binaries.
          IF (EB.LT.0.0) THEN
              ZFAC = 1.0 + ABS(EB - EBH)/ABS(EBH)
          ELSE
              ZFAC = 1.0
          END IF
*       Adopt actual apocentre for perturber selection if R > SEMI.
          IF (SEMI.GT.0.0D0.AND.R(IPAIR).GT.SEMI) THEN
              RAP = SEMI*(1.0 + ECC)
          ELSE
*       Accept separation limit for hyperbolic case.
              RAP = MAX(ZFAC*SEMI,R(IPAIR))
          END IF
*       Ensure extra perturbers at new regularizations (R may be small).
          IF (LKSINT(IPAIR)) THEN
              IPH = IPHASEX(IPAIR)
          ELSE
              IPH = IPHASE
          END IF
          IF (IPH.GT.0.AND.SEMI.GT.0.0) THEN
              RAP = SEMI*(1.0 + ECC)
          END IF
      END IF
*
*       Restrict perturber selection for massive eccentric binary.
      IF (BODY(I).GT.100.0*BODYM.AND.
     &   (R(IPAIR).LT.0.1*SEMI.OR.SEMI.LT.0)) THEN
          RAP = MIN(RMIN,0.1*ABS(SEMI))
      END IF
*
*
*       Set fast search distance and tidal perturbation factor without mass.
      IF (SEMI.LT.0.0) RAP = MAX(R(IPAIR),RMIN)
      RCRIT2 = (100.0*RAP)**2
      RFAC = 2.0*RAP**3/(BODY(I)*GMIN)     ! Use RAP to avoid small R(IPAIR).
*
      IF (KSTAR(I1)+KSTAR(I1+1).EQ.28) RCRIT2 = 3.0*RCRIT2
      IF (KSTAR(I1)+KSTAR(I1+1).EQ.28) RFAC = 10.0*RFAC 
*
*       Select new perturbers from the neighbour list.
      NNB1 = 1
      NNB2 = LIST(1,I) + 1
      DO 10 L = 2,NNB2
          J = LIST(L,I)
          W1 = X(1,J) - X(1,I)
          W2 = X(2,J) - X(2,I)
          W3 = X(3,J) - X(3,I)
          RSEP2 = W1*W1 + W2*W2 + W3*W3
*       Include any merged c.m. or chain c.m. bodies in the fast test.
          IF (RSEP2.LT.RCRIT2.OR.NAME(J).LE.0) THEN
*       Estimate unperturbed distance from tidal limit approximation.
              IF (RSEP2*SQRT(RSEP2).LT.RFAC*BODY(J)) THEN
                  NNB1 = NNB1 + 1
                  LIST(NNB1,I1) = J
              ELSE IF (J.GT.N) THEN
*       Employ a more generous criterion for possible wide binary.
                  JPAIR = J - N
                  IF (LKSINT(JPAIR)) THEN
                      HJ = HX(JPAIR)
                  ELSE
                      HJ = H(JPAIR)
                  END IF
                  RJ = MIN(10.0*ABS(SEMI),-BODY(J)/HJ)
                  IF (RSEP2.LT.CMSEP2*RJ**2) THEN
                      NNB1 = NNB1 + 1
                      LIST(NNB1,I1) = J
                  END IF
              END IF
          END IF
   10 CONTINUE
*
*       Check case of no perturbers (dual purpose).
      IF (NNB1.EQ.1) THEN
*       Add distant perturber and set c.m. step for hyperbolic orbit.
          IF (SEMI.LT.0.0) THEN
              NNB1 = 2
              LIST(2,I1) = LIST(2,I)
              STEP(I1) = STEP(I)
              DT = 2.0*STEP(I1)
              CALL STEPK(DT,DTN)
              STEP(I1) = DTN
              GO TO 20
          END IF
*
*       Restrict look-up time to one period for active PN binary (< 1000*RZ).
          IF (KZ(11).NE.0) THEN
              RP = SEMI*(1.0 - ECC)
              IF (RP.LT.1000.0*RZ) THEN
                  IGR = 1
              ELSE
                  IGR = 0
              END IF
*        Note usual transition from perturbed to unperturbed state in KSINT.
              IF (IGR.GT.0) THEN
                  STEP(I1) = TWOPI*SEMI*SQRT(SEMI/BODY(I))
                  DT = 2.0*STEP(I1)
                  CALL STEPK(DT,DTN)
                  STEP(I1) = DTN
                  GO TO 20
              END IF
          END IF
*
          IF (KZ(27).LE.0) THEN
*       Specify one unperturbed period at apocentre (NB! check STEP(I)).
              STEP(I1) = TWOPI*SEMI*SQRT(SEMI/BODY(I))
              STEP(I1) = MIN(STEP(I1),STEP(I))
*       Include quantization (interval shortened a little so compensate).
              DT = 2.0*STEP(I1)
              CALL STEPK(DT,DTN)
              STEP(I1) = DTN
          ELSE
*       Maintain perturbed motion during Chaos event (not ROCHE/SPIRAL).
              IF (KSTAR(I).EQ.-1) THEN
                  IF (LIST(1,I1).GT.0) THEN
                      NNB1 = 2
                      LIST(2,I1) = N
                  END IF
              ELSE
                  STEP(I1) = TWOPI*SEMI*SQRT(SEMI/BODY(I))
*                 STEP(I1) = MIN(STEP(I1),STEP(I))
*       Avoid possible small period for standard binary (hence use c.m.).
*                 STEP(I1) = MIN(STEP(I1),STEP(I))
*                 DT = 2.0*STEP(I1)
*                 CALL STEPK(DT,DTN)
*                 STEP(I1) = DTN
*       Note BRAKE4 STEP reduction in case of active PN phase.
              END IF
          END IF
      END IF
*
*       Save perturber membership.
   20 LIST(1,I1) = NNB1 - 1
*
*       Include diagnostics for small semi and large perturber number.
      IF (SEMI.LT.0.0) GO TO 30
      IF (SEMI.LT.1.0D-06.AND.LIST(1,I1).GE.1) THEN
          WRITE (6,25)  LIST(1,I1), SEMI, GAMMA(IPAIR)
   25     FORMAT (' KSLIST    NP A G ',I4,1P,2E10.2)
          CALL FLUSH(6)
          STOP
      END IF
*
   30 RETURN
*
      END
