      SUBROUTINE NGF(I,XI,XIDOT,FIN,FDN)
*
*
*       NGF terms for equations of motion.
*       Reference: Aksnes & Mysen, AJ 2011.
*       ------------------------------------
*
      INCLUDE 'commonp.h'
      REAL*8  MFAC,XI(3),XIDOT(3),FIN(3),FDN(3),DV(3)
      REAL*8  MSTAR,ONEC2,XH(3)
*     REAL*8  R0,A2,TU
      REAL*8  R0,A1,A2,A3
*
*
*       Force due to the vaporization of water ice on a rapidly rotating nucleus.
*       R0 in AU, ALPHA in AU/day**2
*
*       Hale-Bopp like Szutowicz et al. (2002)
*     R0 = 5.300D00
*     XM = 2.828D00
*     XN = 3.760D00
*     XK = 3.700D00
*     ALPHA = 0.008860D00
*     A1 = +1.43016818D-08
*     A2 = +0.0094747031D-08
*     A3 = -0.000D-08
*     A1 = +1.069808969190584D-10
*     A2 = -9.383180682535005D-13
*     A3 = -0.000000000000000D-08
*
*       Standard, Delsemme & Miller (1971)
*     Normalizing distance: 2.808 AU
      R0 = 2.808D0
*     Parameters of the model
      XM = 2.15D0
      XN = 5.093D0
      XK = 4.6142D0
      ALPHA = 0.1112620426D0
*     A1 = +6.3224D-08
*     A2 = +0.589D-08
*     A3 = -0.000D-08
*
*      No nongravitational forces
*     A1 = +0.00000000D-08
*     A2 = +0.0000000000D-08
*     A3 = -0.000D-08
*     C/2019 Q4 (Borisov)
*     Reference: JPL 23 (heliocentric ecliptic J2000)
*     Nongrav. accels. using CO driven g(r)
*     Normalizing distance: 5 AU
*      R0 = 5.00000000000D+00
*     Parameters of the model
*     XM = 2.0D0
*     XN = 3.0D0
*     XK = 2.6D0
*     ALPHA = 0.0408373333128795D0
      A1 = A1NGFP
      A2 = A2NGFP
      A3 = A3NGFP
      RI2 = XI(1)*XI(1) + XI(2)*XI(2) + XI(3)*XI(3)
      RI = SQRT(RI2)
      VI2 = XIDOT(1)*XIDOT(1) + XIDOT(2)*XIDOT(2) + XIDOT(3)*XIDOT(3)
      VI = SQRT(VI2)
      XH(1) = XI(2)*XIDOT(3) - XI(3)*XIDOT(2)
      XH(2) = XI(3)*XIDOT(1) - XI(1)*XIDOT(3)
      XH(3) = XI(1)*XIDOT(2) - XI(2)*XIDOT(1)
      XH2 = XH(1)*XH(1) + XH(2)*XH(2) + XH(3)*XH(3)
      XHI = SQRT(XH2)
*
*       Factor g(r) (Eqn. 2).
*       Water ice driven outgassing (symmetric)
      GR = (RI/R0)**XM * (1.0 + (RI/R0)**XN)**XK
*       CO driven outgassing
*     GR = (RI/R0)**2 * (1.0D0 + (RI/R0)**3)**2.6
      GR = ALPHA/GR
*
*       Form the nongravitational acceleration vector.
      DO 5 K = 1,3
          DV(K) = A1*XI(K)/RI + A2*(RI*XIDOT(K)-VI*XI(K))/XHI + A3*XH(K)/XHI
    5 CONTINUE
*
*       Include ALPHA factor.
      DO 10 K = 1,3
          FIN(K) = FIN(K) + GR * DV(K)
   10 CONTINUE
*
      RETURN
*
      END
